/*
 * GameSelectorApplication.java
 *
 * Created on May 19, 2006, 10:01 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package ags.ui.gameSelector;

import ags.communication.TransferHost;
import ags.ui.*;
import java.io.IOException;
import java.util.List;
import ags.game.Game;

/**
 * Application that allows user to browse games and execute one
 * @author blurry
 */
public class GameSelectorApplication extends IApplication  {
    /**
     * Constructor method
     * @param s Virtual framebuffer to use
     */
    public GameSelectorApplication(IVirtualScreen s) {
        super(s);
    }
    
    /**
     * Information bar (not used yet)
     */
    InfoBarWidget infoBar;
    /**
     * Search box (not used yet)
     */
    GameSearchWidget search;
    /**
     * Game results browser
     */
    GameResultsWidget results;
    
    /** Creates a new instance of GameSelectorApplication */
//    public GameSelectorApplication {}
    protected void init() {
        infoBar = new InfoBarWidget(this);
        search = new GameSearchWidget(this);
        results = new GameResultsWidget(this);
        results.setX(1);
        results.setXSize(38);
        results.setY(1);
        results.setYSize(22);
//        addWidget(infoBar);
//        addWidget(search);
        addWidget(results);
        moveToTop(results);
    }
    
    /**
     * Main loop: Wait for user to select game from results and then execute the game
     * @param host Transfer host used to communicate with the remote apple computer
     * @throws java.io.IOException If there was an unrecoverable communication problem
     */
    public void mainLoop(TransferHost host) throws IOException {
        redraw();
        host.sendRawData(getScreen().getBuffer(), 0x0400, 0, getScreen().getBuffer().length);
        while (gameSelected() == null) {
            byte key = host.getKey();
            if (key != 0) {
                handleKeypress(key);
                redraw();
                List<ScreenChange> changes = getChanges();
                byte[] buffer = getScreen().getBuffer();
                for (ScreenChange s:changes)
                    host.sendRawData(buffer, 0x0400, s.start, s.length);
            }
        }
        host.startGame(gameSelected());
        System.out.println("Have fun playing "+gameSelected().getName()+"!");
    }

    /**
     * handle global keypress: None implemented yet
     * @param b Key pressed
     * @return false
     */
    protected boolean handleGlobalKeypress(byte b) {
        return false;
    }

    /**
     * handle invalid keypress: Not implemented yet
     * @param b Key pressed
     * @return false
     */
    protected boolean handleInvalidKeypress(byte b) {
        return false;
    }
    
    /**
     * Set list of games to select from
     * @param games list of games to select from
     */    
    public void setGames(List<Game> games) {
        results.results = games;
    }
    
    /**
     * Get game selection
     * @return selected game or null if there was no selection yet
     */
    public Game gameSelected() {
        return results.selection;
    }
}